# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 2
# Experiment: PMxPM, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR2_strategy.txt
# LLM Suggested Fallback: Not Provided

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR2(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not opp_history:
        return "C"
    
    current_round = len(my_history)
    
    # Check if opponent's code has hard-coded defection
    if "return \"D\"" in opponent_program_code or "return 'D'" in opponent_program_code:
        return "D"
    
    # Late-game strategy (Rounds 9-10)
    if current_round >= 8:
        if all(move == "C" for move in opp_history[:8]):
            if current_round == 8:
                return "D"
            else:
                if opp_history[-1] == "D":
                    return "D"
                else:
                    return "C"
        else:
            if opp_history[-1] == "D":
                return "D"
            else:
                return "C"
    
    # Mid-game strategy (Rounds 2-8)
    if current_round >= 2 and opp_history[-1] == "D" and opp_history[-2] == "D":
        return "D"
    
    # Tit-for-Tat with forgiveness
    if opp_history[-1] == "D":
        return "D"
    else:
        return "C"